<?php
/**
 * Are you back?
 * Copyright 2010 Aries-Belgium
 *
 * $Id$
 */

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook('global_start','areyouback_global_start');
$plugins->add_hook('global_end','areyouback_global_end');

/**
 * Info function for MyBB plugin system
 */
function areyouback_info()
{
	return array(
		"name"			=> "هاك تنبيه من ابتعد عن المنتدي",
		"description"	=> "يقوم بوضع تنبيه للعضو ان ترك المنتدي بدون اي حركه تساله هل موجود",
		"website"		=> "",
		"author"		=> "Aries-Belgium",
		"authorsite"	=> "mailto:aries.belgium@gmail.com",
		"version"		=> "1.2",
		"guid" 			=> "713bad3e2d8d05454b0eef035f2dd1ae",
		"compatibility" => "16*"
	);
}

/**
 * Installation function for MyBB plugin system
 */
function areyouback_install()
{
	global $lang, $db, $mybb;
	
	areyouback__lang_load("areyouback");
	
	// insert settings
	$query = $db->simple_select("settinggroups", "MAX(disporder) as max_disporder");
	$max_disporder = $db->fetch_field($query, "max_disporder");
	
	$gid = $db->insert_query("settinggroups",
		array(
			'name' => "areyouback",
			'title' => $lang->areyouback_settinggroup_title,
			'description' => $lang->areyouback_settinggroup_description,
			'disporder' => $max_disporder+1,
			'isdefault' => 0
		)
	);
	
	$db->insert_query( "settings" ,
		array(
			'name' => "areyouback_delay",
			'title' => $lang->areyouback_setting_delay_title,
			'description' => $lang->areyouback_setting_delay_description,
			'optionscode' => "text",
			'value' => 86400,
			'disporder' => 0,
			'gid' => (int)$gid
		)
	);
	
	// insert template
	$db->insert_query( "templates" ,
		array(
			'title' => "global_areyouback_notice",
			'template' => "<div class=\"areyouback_notice {\$notice_class}\"><strong>{\$lang->areyouback_notice}</strong> <a href=\"{\$confirm_link}\">{\$lang->areyouback_confirm}</a> [<a href=\"{\$ignore_link}\">{\$lang->areyouback_ignore}</a>]</div>",
			'sid' => -2,
			'version' => 1600,
			'status' => "",
			'dateline' => TIME_NOW
		)
	);
}

/**
 * Installation check function for MyBB plugin system
 */
function areyouback_is_installed()
{
	global $db;
	
	$query = $db->simple_select("settinggroups", "gid" , "name='areyouback'");
	return ($db->num_rows($query) == 1);
}

/**
 * Uninstall function for MyBB plugin system
 */
function areyouback_uninstall()
{
	global $db;
	
	// delete settings
	$query = $db->simple_select("settinggroups", "gid" , "name='areyouback'");
	$gid = (int)$db->fetch_field($query, "gid");
	$db->delete_query( "settings" , "gid={$gid}" );
	$db->delete_query( "settinggroups" , "name='areyouback'" );
	
	// delete template
	$db->delete_query("templates", "title='global_areyouback_notice'");
}

/**
 * Activation function for MyBB plugin system
 */
function areyouback_activate()
{
	include MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("header", "#(".preg_quote("{\$pm_notice}").")#i", "{\$areyouback_notice}$1");
}

/**
 * Deactivation function for MyBB plugin system
 */
function areyouback_deactivate()
{
	include MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("header", "#".preg_quote("{\$areyouback_notice}")."#i", "",0);
}

/**
 * Implementation of hook 'header_include'
 * Adds css to the header
 */
function areyouback_global_end()
{
	global $headerinclude, $mybb;
	
	$headerinclude .= "\n" . '<link rel="stylesheet" href="' . $mybb->settings['bburl'] . '/inc/plugins/areyouback/style/areyouback.css" type="text/css" />';
}

/**
 * Implementation of hook 'global_start'
 * - Checks if the user clicked the back-link
 * - Builds the notice to show in the header
 */
function areyouback_global_start()
{
	global $areyouback_notice, $lang, $templates, $mybb, $db;
	
	@session_start();

	areyouback__lang_load("areyouback");
	
	$url = $_SERVER['REQUEST_URI'];
	
	if(isset($mybb->input['iamback']) && $mybb->input['iamback'] == 1)
	{
		$user = array(
			'away' => 0,
			'awaydate' => 0,
			'awayreason' => "",
			'returndate' => ""
		);
		
 		$mybb->user = array_merge($mybb->user,$user);
 		$db->update_query("users", $user, "uid='".(int)$mybb->user['uid']."'");
 		
 		$url = str_replace(array("?iamback=1", "&iamback=1"), "", $url);
 		header("Location: $url");
	}
	
	if(isset($mybb->input['ignoreaway']) && $mybb->input['ignoreaway'] == 1)
	{	
		$_SESSION['ignoreaway'] = true;
		
		$url = str_replace(array("?ignoreaway=1", "&ignoreaway=1"), "", $url);
 		header("Location: $url");
	}
	
	if((int)$mybb->user['away'] == 1  && (!isset($_SESSION['ignoreaway']) || $_SESSION['ignoreaway'] !== true) && (TIME_NOW - $mybb->user['awaydate']) > (int)$mybb->settings['areyouback_delay'])
	{
		$returndate = explode("-", $mybb->user['returndate']);
		$notice_class = "areyouback_yellow";
		if(count($returndate) == 3)
		{
			list($d,$m,$y) = $returndate;
			$returntime = gmmktime(0,0,0,$m,$d,$y);
			$notice_class = $returntime > TIME_NOW ? "areyouback_yellow" : "areyouback_red";
		}
		$confirm_link = $url . (strpos($url, "?") === false ? "?" : "&amp;") . "iamback=1";
		$ignore_link = $url . (strpos($url, "?") === false ? "?" : "&amp;") . "ignoreaway=1";
		eval("\$areyouback_notice = \"".$templates->get("global_areyouback_notice")."\";");
	}
}

/**
 * Helper function to load language files for the plugin
 */
function areyouback__lang_load($file, $supress_error=false)
{
	global $lang;
	
	$plugin_name = str_replace('__lang_load', '', __FUNCTION__);
	$plugin_lang_dir = MYBB_ROOT."inc/plugins/{$plugin_name}/lang/";
	if(empty($file)) $file = $plugin_name;
	
	$langparts = explode("/", $lang->language, 2);
	$language = $langparts[0];
	if(isset($langparts[1]))
	{
		$dir = "/".$langparts[1];
	}
	else
	{
		$dir = "";
	}
	
	if(file_exists($plugin_lang_dir.$language.$dir."/{$file}.lang.php"))
	{
		require_once $plugin_lang_dir.$language.$dir."/{$file}.lang.php";
	}
	elseif(file_exists($plugin_lang_dir."english".$dir."/{$file}.lang.php"))
	{
		require_once $plugin_lang_dir."english".$dir."/{$file}.lang.php";
	}
	else
	{
		if($supress_error != true)
		{
			die($plugin_lang_dir."english".$dir."/{$file}.lang.php");
		}
	}
	
	if(is_array($l))
	{
		foreach($l as $key => $val)
		{
			if(empty($lang->$key) || $lang->$key != $val)
			{
				$lang->$key = $val;
			}
		}
	}
}